;==============================================================================;
;==	PicConfig.inc									Last Update 2018/04/03
;==	pic16f145x_family										Saka Softwares
;==============================================================================;
;== PIC16の各コンフィグを載せています。
;== コンフィグワードは、MPLAB X IDEの生成機能を使っています。
;== ([Window]-[PIC Memory Views]-[Configuration Bits]からできます。)
;== ユーザープログラムのコンフィグワードと合わせる必要があります。
;== (勿論USBが使用できることが前提です。)
;==============================================================================;
#define INTERNAL_USB_CLOCK			; 外部発振器を使用する場合はコメントアウトしてください。
	
;==	PIC16(L)F145x =============================================================;
#ifdef __16F1454
	list p=PIC16F1454
	#include "p16f1454.inc"
#endif
#ifdef __16LF1454
	list p=PIC16LF1454
	#include "p16lf1454.inc"
#endif
#ifdef __16F1455
	list p=PIC16F1455
	#include "p16f1455.inc"
#endif
#ifdef __16LF1455
	list p=PIC16LF1455
	#include "p16lf1455.inc"
#endif
#ifdef __16F1459
	list p=PIC16F149
	#include "p16f1459.inc"
#endif
#ifdef __16LF1459
	list p=PIC16LF149
	#include "p16lf1459.inc"
#endif
;== Configuration Word
#ifdef INTERNAL_USB_CLOCK
	__CONFIG _CONFIG1, _FOSC_INTOSC & _WDTE_SWDTEN & _PWRTE_ON & _MCLRE_OFF & _CP_OFF & _BOREN_ON & _CLKOUTEN_OFF & _IESO_OFF & _FCMEN_OFF
	__CONFIG _CONFIG2, _WRT_OFF & _CPUDIV_NOCLKDIV & _USBLSCLK_48MHz & _PLLMULT_3x & _PLLEN_ENABLED & _STVREN_ON & _BORV_LO & _LPBOR_OFF & _LVP_OFF
#else
	__CONFIG _CONFIG1, _FOSC_HS & _WDTE_SWDTEN & _PWRTE_ON & _MCLRE_OFF & _CP_OFF & _BOREN_ON & _CLKOUTEN_OFF & _IESO_OFF & _FCMEN_OFF
	__CONFIG _CONFIG2, _WRT_OFF & _CPUDIV_NOCLKDIV & _USBLSCLK_48MHz & _PLLMULT_4x & _PLLEN_ENABLED & _STVREN_ON & _BORV_LO & _LPBOR_OFF & _LVP_OFF
#endif

;== end of file ===============================================================;
